/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.xfw.repair.panel;

import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.pa.problem.Problem;
import com.ibm.hwmca.fw.service.managedsystem.ManagedSystem;
import com.ibm.hwmca.fw.service.managedsystem.ManagedSystemManager;
import com.ibm.hwmca.fw.tasklet.SynchronousPanelTasklet;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.xfw.pa.problem.CommonProblem;
import com.ibm.hwmca.xfw.panel.repair.MachineInfoPanelBean;
import com.ibm.hwmca.xfw.repair.panel.XFConstants;
import com.ibm.ui.framework.IllegalUserDataException;
import java.util.Map;

public class MachineInfoPanelHandler {
    private static final String TRACE_MASKT = "XRVX042T";
    private static final String TRACE_MASKF = "XRVX042F";
    private static final String TRACE_MASKD = "XRVX042D";
    private SynchronousPanelTasklet displayHandle;

    public MachineInfoPanelHandler(SynchronousPanelTasklet displayHandle) {
        Trace.trace(TRACE_MASKT, "<> MachineInfoPanelHandler ctor");
        this.displayHandle = displayHandle;
    }

    public void display(Map userData) throws HException {
        Problem problem = (Problem)userData.get("PROBLEM");
        if (problem instanceof CommonProblem) {
            CommonProblem commonProblem = (CommonProblem)problem;
            ManagedSystem managedSystem = ManagedSystemManager.getManager().getManagedSystem(commonProblem.getFailingSystem().getMachineType(), commonProblem.getFailingSystem().getMachineModel(), commonProblem.getFailingSystem().getMachineSerial());
            try {
                MachineInfoPanelBean mipBean = new MachineInfoPanelBean();
                mipBean.load();
                mipBean.setSystemNameOutput("Local");
                mipBean.setMachineTypeOutput(commonProblem.getFailingSystem().getMachineType());
                mipBean.setMachineModelOutput(commonProblem.getFailingSystem().getMachineModel());
                mipBean.setMachineSerialNumberOutput(commonProblem.getFailingSystem().getMachineSerial());
                mipBean.setMachinePMHOutput(commonProblem.getPMH());
                mipBean = (MachineInfoPanelBean)this.displayHandle.replace(XFConstants.RES_FILE_NAME, "MachineInfoPanel", mipBean);
            }
            catch (IllegalUserDataException e) {
                Trace.trace(TRACE_MASKT, "<-! MachineInfoPanelHander ctor; IllegalUserDataException setting up panel[" + (Object)((Object)e) + "]");
                throw new HException(e);
            }
        } else {
            Trace.trace(TRACE_MASKT, "<-! MachineInfoPanelHandler requires a CommonProblem; found [" + problem + "]");
            throw new HException("MachineInfoPanelHandler requires a CommonProblem; found [" + problem + "]");
        }
    }
}

